#!/bin/sh
# Script to install the codexrepo on a Fedora system
#

if [[ $(id -u) -ne 0 ]] ; then echo "Please run as root or sudo" ; exit 1 ; fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

repoLocation=$DIR

if [ ! -d /etc/yum.repos.d ];
then
    echo "Not a compatible system!"
    exit 1
fi

if [ ! -d ${repoLocation} ];
then
    echo "Could not find repo at ${repoLocation}"
    exit 1
fi

echo "Clearing Codex repo metadata from previous installation"

yum clean metadata

echo "Installing software repository"

cat << EOF > /etc/yum.repos.d/codex.repo
[codex]
name=Codex Digital
baseurl=file://${repoLocation}
enabled=1
gpgcheck=0
EOF
