/*
**  %Z% %I% %W% %G% %U%
**
**  ZZ_Copyright_BEGIN
**
**
**  Licensed Materials - Property of IBM
**
**  IBM Linear Tape File System Single Drive Edition Version 2.2.1 for Linux and Mac OS X
**
**  Copyright IBM Corp. 2010, 2015
**
**  This file is part of the IBM Linear Tape File System Single Drive Edition for Linux and Mac OS X
**  (formally known as IBM Linear Tape File System)
**
**  The IBM Linear Tape File System Single Drive Edition for Linux and Mac OS X is free software;
**  you can redistribute it and/or modify it under the terms of the GNU Lesser
**  General Public License as published by the Free Software Foundation,
**  version 2.1 of the License.
**
**  The IBM Linear Tape File System Single Drive Edition for Linux and Mac OS X is distributed in the
**  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
**  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**  See the GNU Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
**  or download the license from <http://www.gnu.org/licenses/>.
**
**
**  ZZ_Copyright_END
**
*************************************************************************************
**
** COMPONENT NAME:  IBM Linear Tape File System
**
** FILE NAME:       plugin.h
**
** DESCRIPTION:     Declares functions for working with libltfs plugins.
**
** AUTHORS:         Brian Biskeborn
**                  IBM Almaden Research Center
**                  bbiskebo@us.ibm.com
**
*************************************************************************************
*/

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include "config_file.h"

struct libltfs_plugin {
	void *lib_handle;  /**< Handle to the shared library implementing the plugin */
	void *ops;         /**< Pointer to the plugin's function list */
	void *messages;    /**< Handle to the plugin message bundle generated by ltfsprintf.c */
};

/**
 * Load a plugin (a shared library that implements a particular set of operations).
 * This function may be called multiple times for the same plugin.
 * It is not reentrant.
 * @param pl Plugin structure to populate.
 * @param type Plugin type, must be "iosched", "changer", "kmi" or "driver".
 * @param name The name of the plugin to load.
 * @param config Configuration structure to search for the plugin path.
 * @return 0 on success or a negative value on error.
 */
int plugin_load(struct libltfs_plugin *pl, const char *type, const char *name,
	struct config_file *config);

/**
 * Unload a previously loaded plugin. This should be called once for each call to @plugin_load.
 * This function is not reentrant.
 * @param pl Plugin to unload.
 * @return 0 on success or a negative value on error.
 */
int plugin_unload(struct libltfs_plugin *pl);

/**
 * Show usage of a plugin (a shared library that implements a particular set of operations).
 * @param type Plugin type, must be "iosched", "kmi" or "driver".
 * @param config Configuration structure to search for the plugin path.
 */
void plugin_usage(const char *type, struct config_file *config);

#endif /* __PLUGIN_H__ */

