#!/bin/sh
set -e

WKHTMLTOIMAGE=/usr/bin/wkhtmltoimage
if [ -f /usr/local/codex/bin/wkhtmltoimage ]; then
  WKHTMLTOIMAGE=/usr/local/codex/bin/wkhtmltoimage
fi

WKHTMLTOPDF=/usr/bin/wkhtmltopdf
if [ -f /usr/local/codex/bin/wkhtmltopdf ]; then
  WKHTMLTOPDF=/usr/local/codex/bin/wkhtmltopdf
fi

ASSETFOLDER=/usr/share/codex/reports
if [ -f /etc/codex/report-qc.xsl ]; then
  ASSETFOLDER=/etc/codex/reports
fi
if [ -f "/Library/Application Support/Codex/reports/report-qc.xsl" ]; then
  ASSETFOLDER="/Library/Application Support/Codex/reports"
fi
xsltproc --maxdepth 100000 "${ASSETFOLDER}/report-qc.xsl" "$1" > "${ASSETFOLDER}/temp.html"

for filename in "${@:2}"; do
  ext=${filename##*.}
  ext=$(echo "$ext" | tr 'A-Z' 'a-z')
  echo $filename
  if [[ "$ext" == "png" ]]; then
    $WKHTMLTOIMAGE --format png --quality 100 --width 2048 --zoom 2 "${ASSETFOLDER}/temp.html" "$filename" > /dev/null 2> /dev/null

  elif [[ "$ext" == "pdf" ]]; then
    OPTIONS="--dpi 96 --disable-smart-shrinking"
    $WKHTMLTOPDF --footer-center '[page]/[topage]' -O Landscape ${OPTIONS} "${ASSETFOLDER}/temp.html" "${ASSETFOLDER}/temp.pdf" > /dev/null 2> /dev/null
    mv "${ASSETFOLDER}/temp.pdf" "$filename"

  fi
done
rm "${ASSETFOLDER}/temp.html"
