<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes="exsl" >

    <!-- the main gubbins -->
    <xsl:template match="/">

        <html>

            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
              <link rel="stylesheet" type="text/css" href="report.css" />
              <title>Codex EDL Error Report</title>
            </head>

            <body>

                <!-- set-up some (possibly) useful variables -->

                <!-- Print logo, header and column titles -->
                <table width="1000" height="98" border="0" cellpadding="0" cellspacing="0">

                    <!-- logo -->
                    <tr>
                        <td colspan="18"><div align="right"><img src="edl-header.gif" alt="" width="709" height="111" /></div></td>
                    </tr>
                    <tr>
                        <td colspan="18">
                            <img src="report-transp.gif" alt="" width="14" height="10" />
                        </td>
                    </tr>

                    <!-- EDL Name -->
                    <tr>
                        <td colspan="18"><table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#CCCCCC">
                            <tr>
                                <td width="10" height="17" valign="middle" bgcolor="#dfdfdf"><h5>
                                    <img src="report-transp.gif" alt="" width="11" height="20" />
                                </h5></td>

                                <td width="292" valign="middle" bgcolor="#dfdfdf"><div align="left">
                                    <strong>EDL NAME: </strong>
                                    <xsl:value-of select="EDLPullErrorReport/EDLName" />
                                </div></td>
                            </tr>
                        </table></td>
                    </tr>

                    <!-- gap between EDL Name and table column headings-->
                    <tr>
                        <td height="15" colspan="18" align="left" valign="top">
                            <img src="report-transp.gif" alt="" width="14" height="14" />
                        </td>
                    </tr>

                    <!-- table column headings -->
                    <tr>

                        <td width="10" height="17" valign="middle" bgcolor="#dfdfdf"><h5>
                            <img src="report-transp.gif" alt="" width="11" height="20" />
                        </h5></td>

                        <td width="50" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="left">ENTRY ID
                            </h5>
                        </td>

                        <td height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="left">ERROR MSG
                            </h5>
                        </td>

                        <td width="20" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">EDL TC RANGE
                            </h5>
                        </td>

                        <td width="20" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">ROLL
                            </h5>
                        </td>

                        <td width="20" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">CLIP NAME
                            </h5>
                        </td>

                        <td width="20" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">CLIP TC RANGE
                            </h5>
                        </td>

                        <td width="20" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">CLIP UUID
                            </h5>
                        </td>

                        <td width="140" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">ARCHIVE LOCATIONS
                            </h5>
                        </td>

                        <td width="10" height="17" valign="middle" bgcolor="#dfdfdf"><h5>
                            <img src="report-transp.gif" alt="" width="11" height="20" />
                        </h5></td>
                    </tr>

                    <!-- loop round printing details for each shot -->
                    <xsl:for-each select="EDLPullErrorReport/EDLErrorEntry">

                        <!-- create some per shot variables -->


                        <!-- print the table row for this shot -->
                        <tr height="12">

                            <td><h6>
                                <xsl:text>&#160;</xsl:text>
                            </h6></td>

                            <xsl:choose>
                                 <xsl:when test="LocationIdx = 0">
                                    <td><h6 align="left">
                                        <xsl:value-of select="EntryId" />
                                    </h6></td>

                                    <td><h6 align="left">
                                        <xsl:value-of select="ErrorMsg" />
                                    </h6></td>

                                    <td><h6 align="center">
                                        <xsl:value-of select="EDLStartTC" />
                                        <xsl:text> - </xsl:text>
                                        <xsl:value-of select="EDLEndTC" />
                                    </h6></td>

                                    <td><h6 align="center">
                                        <xsl:value-of select="Roll" />
                                    </h6></td>

                                    <td><h6 align="center">
                                        <xsl:value-of select="ClipName" />
                                    </h6></td>

                                    <td><h6 align="center">
                                        <xsl:value-of select="ClipStartTC" />
                                        <xsl:text> - </xsl:text>
                                        <xsl:value-of select="ClipEndTC" />
                                    </h6></td>

                                    <td><h6 align="center">
                                        <xsl:value-of select="BackboneClipUuid" />
                                    </h6></td>

                                </xsl:when>

                                <xsl:otherwise>
                                    <td><h6 align="left"></h6></td>
                                    <td><h6 align="left"></h6></td>
                                    <td><h6 align="center"></h6></td>
                                    <td><h6 align="center"></h6></td>
                                    <td><h6 align="center"></h6></td>
                                    <td><h6 align="center"></h6></td>
                                    <td><h6 align="center"></h6></td>
                                </xsl:otherwise>
                            </xsl:choose>

                            <td><h6 align="center">
                                <xsl:value-of select="Location" />
                            </h6></td>

                            <td><h6>
                                <xsl:text>&#160;</xsl:text>
                            </h6></td>
                        </tr>
                    </xsl:for-each>

                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
