<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes="exsl" >

    <!-- date conversion -->
    <xsl:template name="formatDate">
        <xsl:param name="dateString" />

        <xsl:choose>

            <xsl:when test="string-length($dateString) = 8">

                <xsl:variable name="year" select="substring($dateString, 1, 4)" />
                <xsl:variable name="month" select="substring($dateString, 5, 2)" />
                <xsl:variable name="day" select="substring($dateString, 7, 2)" />

                <xsl:value-of select="format-number($day, '##')" />
                <xsl:text> </xsl:text>

                <xsl:choose>
                    <xsl:when test="$month = '01'">Jan</xsl:when>
                    <xsl:when test="$month = '02'">Feb</xsl:when>
                    <xsl:when test="$month = '03'">Mar</xsl:when>
                    <xsl:when test="$month = '04'">Apr</xsl:when>
                    <xsl:when test="$month = '05'">May</xsl:when>
                    <xsl:when test="$month = '06'">Jun</xsl:when>
                    <xsl:when test="$month = '07'">Jul</xsl:when>
                    <xsl:when test="$month = '08'">Aug</xsl:when>
                    <xsl:when test="$month = '09'">Sep</xsl:when>
                    <xsl:when test="$month = '10'">Oct</xsl:when>
                    <xsl:when test="$month = '11'">Nov</xsl:when>
                    <xsl:when test="$month = '11'">Dec</xsl:when>
                </xsl:choose>

                <xsl:text> </xsl:text>
                <xsl:value-of select="format-number($year, '00')" />

            </xsl:when>

            <xsl:otherwise>
              <xsl:value-of select="$dateString"/>
            </xsl:otherwise>

        </xsl:choose>

    </xsl:template>

    <!-- the main gubbins -->
    <xsl:template match="/">

        <html>

            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
              <link rel="stylesheet" type="text/css" href="report.css" />
              <title>Codex Media Report</title>
            </head>

            <body>

                <!-- set-up some (possibly) useful variables -->

                <xsl:variable name="author" select="CodexMediaTaskXMLList/Author" />

                <!-- Print logo, header and column titles -->
                <table width="1000" height="98" border="0" cellpadding="0" cellspacing="0">

                    <!-- logo -->
                    <tr>
                        <td colspan="18"><div align="right"><img src="media-header.gif" alt="" width="709" height="111" /></div></td>
                    </tr>
                    <tr>
                        <td colspan="18">
                            <img src="report-transp.gif" alt="" width="14" height="10" />
                        </td>
                    </tr>

                    <!-- production/author/shootdate -->
                    <tr>
                        <td colspan="18"><table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#CCCCCC">
                            <tr>
                                <td width="15" height="20" bgcolor="#dfdfdf">
                                    <img src="report-transp.gif" alt="" width="14" height="12" />
                                </td>

                                <td width="125" valign="middle" bgcolor="#dfdfdf">
                                    <div align="left">
                                        <strong> MUL: </strong>
                                        <xsl:value-of select="CodexMediaTaskXMLList/MUL" />
                                    </div>
                                </td>

                                <td width="40" valign="middle" bgcolor="#dfdfdf">
                                    <img src="report-transp.gif" alt="" width="14" height="12" />
                                </td>

                                <td width="335" valign="middle" bgcolor="#dfdfdf">
                                    <div align="middle">
                                        <strong>MEDIA TYPE: </strong>
                                        <xsl:value-of select="CodexMediaTaskXMLList/MediaPortType" />
                                    </div>
                                </td>

                                <td width="40" valign="middle" bgcolor="#dfdfdf">
                                    <img src="report-transp.gif" alt="" width="14" height="12" />
                                </td>

                                <td width="200" valign="middle" bgcolor="#dfdfdf"><div align="middle">
                                  <xsl:if test="$author != ''">
                                    <strong>AUTHOR: </strong>
                                    <xsl:value-of select="CodexMediaTaskXMLList/Author" />
                                  </xsl:if>
                                </div></td>

                                <td width="40" height="20" bgcolor="#dfdfdf">
                                    <img src="report-transp.gif" alt="" width="100" height="20" />
                                </td>

                                <td width="280" valign="middle" bgcolor="#dfdfdf"><div align="right">
                                    <strong>DATE: </strong>
                                    <xsl:value-of select="CodexMediaTaskXMLList/Date" />
                                </div></td>

                                <td width="15" height="20" bgcolor="#dfdfdf">
                                    <img src="report-transp.gif" alt="" width="18" height="20" />
                                </td>
                            </tr>
                        </table></td>
                    </tr>

                    <!-- summary line -->
                    <tr>
                        <td colspan="18"><img src="report-transp.gif" alt="" width="14" height="14" /></td>
                    </tr>

                    <tr>
                        <td colspan="18">
                            <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#CCCCCC">
                                <tr>
                                    <td width="14" height="20" bgcolor="#dfdfdf">
                                        <img src="report-transp.gif" alt="" width="14" height="20" />
                                    </td>

                                    <td valign="middle" bgcolor="#dfdfdf"><div align="middle">

                                        <strong>SUMMARY: </strong>

                                        <xsl:value-of select="CodexMediaTaskXMLList/NumShots" />
                                        <xsl:choose>
                                            <xsl:when test="number(CodexMediaTaskXMLList/NumShots) > 1">
                                                <xsl:text> clips; </xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text> clip; </xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>

                                        <xsl:value-of select="format-number(CodexMediaTaskXMLList/TotalFrames, ',###,###')" />
                                        <xsl:choose>
                                            <xsl:when test="number(CodexMediaTaskXMLList/TotalFrames) > 1">
                                                <xsl:text> frames; </xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text> frame; </xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>

                                        <xsl:value-of select="format-number(CodexMediaTaskXMLList/TotalSize, ',###,###')" />
                                        <xsl:text> GB</xsl:text>

                                    </div></td>

                                    <td width="14" height="20" bgcolor="#dfdfdf">
                                        <img src="report-transp.gif" alt="" width="14" height="20" />
                                    </td>

                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- gap between summary and table column headings-->
                    <tr>
                        <td height="15" colspan="18" align="left" valign="top">
                            <img src="report-transp.gif" alt="" width="14" height="14" />
                        </td>
                    </tr>

                    <!-- table column headings -->
                    <tr>

                        <td width="10" height="17" valign="middle" bgcolor="#dfdfdf"><h5>
                            <img src="report-transp.gif" alt="" width="11" height="20" />
                        </h5></td>

                        <td width="140" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="left">JOB</h5>
                        </td>

                        <td width="140" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="left">TASK NAME</h5>
                        </td>

                        <td width="150" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">
                                <xsl:text>CREATION DATE</xsl:text>
                            </h5>
                        </td>

                        <td width="150" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">MODIFICATION DATE</h5>
                        </td>

                        <td width="100" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">TYPE</h5>
                        </td>

                        <td width="100" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">STATE</h5>
                        </td>

                        <td width="100" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">INPUT MEDIA</h5>
                        </td>

                        <td width="100" height="17" valign="middle" bgcolor="#dfdfdf">
                            <h5 align="center">OUTPUT MEDIA</h5>
                        </td>

                        <td width="10" height="17" valign="middle" bgcolor="#dfdfdf"><h5>
                            <img src="report-transp.gif" alt="" width="18" height="17" />
                        </h5></td>
                    </tr>

                    <!-- loop round printing details for each shot -->
                    <xsl:variable name="dark" select="0"/>
                    <xsl:for-each select="CodexMediaTaskXMLList/MediaTaskList/TaskMarker">

                        <!-- print the table row for this shot -->
                        <tr height="12">

                            <!-- set background colour for alternating stripes -->
                            <xsl:if test="Dark = 1">
                                <xsl:attribute name="bgcolor">#dfdfdf</xsl:attribute>
                            </xsl:if>

                            <td><h6>
                                <xsl:text>&#160;</xsl:text>
                            </h6></td>

                            <td>
                                <h6 align="left">
                                    <xsl:if test="JobUuid[not(.=preceding::JobUuid)]">
                                        <xsl:value-of select="WorkTemplateName"/>
                                    </xsl:if>
                                </h6>
                            </td>

                            <td>
                                <h6 align="left">
                                    <xsl:value-of select="TaskName" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="CreationTime" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="ModificationTime" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="TaskType" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="TaskState" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="TaskInput" />
                                </h6>
                            </td>

                            <td>
                                <h6 align="middle">
                                    <xsl:value-of select="TaskOutputMUL" />
                                </h6>
                            </td>

                            <td><h6>
                                <xsl:text>&#160;</xsl:text>
                            </h6></td>
                        </tr>
                    </xsl:for-each>
                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
