#!/bin/sh

delete_partition() {
    # delete any partitions from the drive
    # d = delete current partition
    # w = write to disk
    /sbin/fdisk "$1" <<****
d
w
****
}

create_partition() {
    # create empty partitions with linux raid autodetect type
    # d = delete current partition
    # n = new partition
    # p = primary partition
    # then defaults - first partition, start sector, last sector
    # t = change type
    # fd = linux auto dectect raid
    # w = write to disk
    /sbin/fdisk "$1" <<****
d
n
p



t
fd
w
****
}

# clear the devices
for i in $*; do
    # if the device is a whole disk then we
    # delete all the partitions, if the device is
    # the first partition (i.e. ending in a 1 or p1,
    # e.g. /dev/sdc1 or /dev/nvme0n1p1) then we 
    # create that partition
    if [[ "$i" == /dev/nvme* ]]; then
        if [[ "$i" == *p1 ]]; then
            disk=${i::-2}
            create_partition $disk
        else
            delete_partition $i
        fi
    else
        if [[ "$i" == *1 ]]; then
            disk=${i::-1}
            create_partition $disk
        else
            delete_partition $i
        fi
    fi
done
exit 0
