#!/bin/sh

let NUM_DISKS=$#-5

# e.g. raid.sh vault:xfs5-1 xfs5-1 xfs /dev/md200 5 /dev/sdb1 /dev/sdc1 /dev/sdd1 /dev/sde1
RAID_LABEL=$1
LABEL=$2
FS=$3
DEVICE=$4
LEVEL=$5

partprobe ${*:6}

unraid.sh $DEVICE ${*:6}
clear.sh ${*:6}

partprobe ${*:6}

EXFAT_STR="ExFAT"

# Use 512K for NVMe as 4K caused issues with Unigen drives currently under evaluation
if [[ ("${LEVEL}" == "5" && "${FS,,}" == "${EXFAT_STR,,}") || ("$6" == /dev/nvme*) ]]; then
   mdadm --create --verbose --chunk=512K --bitmap=none --run --name="$RAID_LABEL" $DEVICE --level=$LEVEL --auto=yes --raid-devices=$NUM_DISKS ${*:6}
else
   mdadm --create --verbose --chunk=4 --run --name="$RAID_LABEL" $DEVICE --level=$LEVEL --auto=yes --raid-devices=$NUM_DISKS ${*:6}
fi

RET=$?

if [ $RET -ne 0 ]; then
   echo "Failed to create RAID-$LEVEL $LABEL $FS ($DEVICE) with ${*:6}"
   echo "Exit status $RET"
   exit $RET
fi

# compare ignoring case
if [ "${FS,,}" = "${EXFAT_STR,,}" ]; then
    mkexfat -f -v:$LABEL $DEVICE
else
    mkfs.xfs -l size=128m -L $LABEL -f $DEVICE
fi
RET=$?
if [ $? -ne 0 ]; then
   echo "Failed to format RAID-$LEVEL $LABEL ($DEVICE) with ${*:6} as $FS"
   echo "Exit status $RET"
   exit $RET
fi

exit 0
