#!/bin/sh

DEVICE=$1
DEVICE_SUBSTRING=${DEVICE:5}
if [ "$DEVICE_SUBSTRING" == "" ]; then
   exit 1
fi

# xfs
# Although this is parameter is meant to help with open lots of
# files it seems to make little difference being anything else
sysctl -w fs.xfs.rotorstep=1

# Using raidtest3.sh the following were determined to be optimal for
# current drives (8x1TB) on internal storage copying 10MB files in
# chunks of 32KB

# raid settings
echo 16384 > /sys/block/$DEVICE_SUBSTRING/md/stripe_cache_size
blockdev --setra 16384 /dev/$DEVICE_SUBSTRING

# per disk settings
PARTITIONS=${*:2}
for PARTITION in $PARTITIONS; do
    DRIVE=${PARTITION:5:-1}
    blockdev --setra 1024 /dev/$DRIVE
    echo 256 > /sys/block/$DRIVE/queue/max_sectors_kb
done

exit 0
