#!/bin/sh

# unmount file system and stop raid device
umount $1
mdadm --stop $1

function zero_superblock_if_present()
{
    # check if there is a super block
    # n.b. check for superblock magic number a92b4efc
    # not just exit code from mdadm because it can return
    # 0 for a MBR
    mdadm -E $1 | grep a92b4efc &> /dev/null
    ret=$?
    if [ $ret -eq 0 ]; then
        mdadm --zero-superblock $1
    fi
}

for device in ${@:2}; do

    # deduce disk and partition names
    # device may be a whole disk or partition
    if [[ "$device" == /dev/nvme* ]]; then
        if [[ "$device" != *p1 ]]; then
            # this is a whole disk device
            disk=$device
            partition=${device}p1
        else
            # this is a partition
            disk=${device::-2}
            partition=$device
        fi
    else
        if [[ "$device" != *1 ]]; then
            # this is a whole disk device
            disk=$device
            partition=${device}1
        else
            # this is a partition
            disk=${device::-1}
            partition=$device
        fi
    fi

    zero_superblock_if_present $disk
    zero_superblock_if_present $partition
    partprobe $partition
done

exit 0
