#!/bin/sh

# Helper command script to allow TangentHub auto-select to work on linux. This would usually be run as
# as an optional follow-up action after the software package has been installed. 
#
# SVN: $Revision: 66 $

# test for the environment setting that is required
if [ -z $DISPLAY ]; then

    # we are running with stripped environment settings which means we have probably been called
    # with a standard sudo command
    echo "This command must be run with standard environment definitions."
    echo "(Don't run the command using 'sudo'.)"
    exit

fi

# define a local file and a location used by x during its start up sequence
LOCAL_HUB_FILE="tangent-hub.sh"
XINIT_HUB_FILE="/etc/X11/xinit/xinitrc.d/tangent-hub.sh"

# we expect an argument to determine the required action
if [ "$1" == "install" ]; then

    # log the action
    echo "Enabling TangentHub access to user desktop windows"
    
    # build the script as a local file first
    echo "#!/bin/sh" > "$LOCAL_HUB_FILE"
    echo "xhost SI:localuser:root > /dev/null 2>&1" >> "$LOCAL_HUB_FILE"
    
    # run the file from here to enable hub access without requiring a restart
    source ./"$LOCAL_HUB_FILE"
    
    # move the file to the system folder that x will run each time it is started to allow local
    # root account access to user x servers
    sudo mv -f "$LOCAL_HUB_FILE" "$XINIT_HUB_FILE"
      
    # apply root ownership and correct permissions appropriate for the file's location
    sudo chown root:root "$XINIT_HUB_FILE"
    sudo chmod 755 "$XINIT_HUB_FILE"

    # tidy up any local file in case of error
    rm -f "$LOCAL_HUB_FILE"
    
    # insert a small delay before restarting the hub service to catch the status change
    sleep 3
    sudo /sbin/service tangenthub restart
      
elif [ "$1" == "remove" ]; then

    # log the action
    echo "Removing TangentHub access to user desktop windows"
    
    # delete the script file if found
    if [ -f "$XINIT_HUB_FILE" ]; then
        sudo rm -f "$XINIT_HUB_FILE"
    fi
    
    # we do not explicitly remove the xhost setting here as there may be other reasons for it to be active
    # so leave the system as it is and the next log in will restore the appropriate environment
    
    # insert a small delay before restarting the hub service to catch the status change
    sleep 3
    sudo /sbin/service tangenthub restart

else

    # print usage hint
    echo "Usage: autoselect.sh install|remove"

fi
